﻿using System;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using VeteransAffairs.Registries.BusinessManager;

public partial class DataExportImaging : Page
{
    private UserAccountManager _currentUser;

    private readonly PatientImagingDataExportManager _patientImagingDataExportManager;

    public DataExportImaging()
    {
        _patientImagingDataExportManager = new PatientImagingDataExportManager();
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            _currentUser = (UserAccountManager)HttpContext.Current.User;
        }
        catch
        {
            Response.Redirect("ErrorPage.aspx?id=505");
        }

        // Check whether the user has EFR TEFSC COORDINATOR role
        if (_currentUser.GetRoles().Contains(4))
        {
            GetImagingDataExport();

            Response.ClearContent();
            Response.AddHeader("content-disposition", "attachment; filename=DataExport.xls");
            Response.ContentType = "application/vnd.ms-excel";
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    private void GetImagingDataExport()
    {
        var imagingExportTable = _patientImagingDataExportManager.GetImagingDataExport();
        if (imagingExportTable != null)
        {
            GridView1.DataSource = imagingExportTable;
            GridView1.DataBind();
        }
    }

    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        // Some text values will mistakenly interpreted as numeric by Excel, such as postal codes and social security numbers
        // Such fields may loose their trailing zeros, such as zip code "00700" converts into number 700
        // Use the code below to explicitely convert affected columns into text format
        // Column numbers start with 0

        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            // MJ, 01/25/2011, Cells values are referenced by ColumnName instead of column Index
            var tryGetSsn = GetCellByBoundFieldName(e.Row, "SSN");
            if (tryGetSsn != null)
                tryGetSsn.Attributes.Add("class", "text");
        }
    }

    public override void VerifyRenderingInServerForm(Control control)
    {
    }

    DataControlFieldCell GetCellByBoundFieldName(GridViewRow row, string fieldName)
    {
        foreach (DataControlFieldCell cell in row.Cells)
        {
            BoundField bf = cell.ContainingField as BoundField;
            if (bf != null && bf.DataField.Equals(fieldName, StringComparison.OrdinalIgnoreCase))
                return cell;
        }
        return null;
    }
}
